import UIKit

class ViewController: UIViewController, UIScrollViewDelegate
{

    @IBOutlet weak var myScrollView: UIScrollView!
    
    override func viewDidLoad()
    {
        super.viewDidLoad()
        
        myScrollView.contentSize = CGSize(width: 600.0,
                                          height: 1800.0)
        myScrollView.delegate = self
    }
    
    func scrollViewDidScroll(_ scrollView: UIScrollView)
    {
        print("scrollViewDidScroll")
    }
    
    func scrollViewDidEndDragging(_ scrollView: UIScrollView,
                                  willDecelerate decelerate: Bool)
    {
        print("scrollViewDidEndDragging")
        if ( decelerate )
        {
            print("Slowing Down")
        }
    }

    func scrollViewWillBeginDragging(_ scrollView: UIScrollView)
    {
        print("scrollViewWillBeginDragging")

    }
    
    func scrollViewDidEndDecelerating(_ scrollView: UIScrollView)
    {
        print("It STOPPED")

    }
    
}

